import { View, FlatList, StyleSheet, ScrollView } from 'react-native';
import React from 'react';
import B2bPrices from './B2bPrices';
import RegularItemPrice from './RegularItemPrice';
import dpr from '../../../../../Utilities/CustomStyleAttribute/dpr';

const ItemPrice = (props) => {
    const { type, selectedVariation, b2b } = props || {};
    const { 
        success, 
        value: {
            isEnableB2B: selectedIsEnableB2B, 
            b2bData: selectedB2bData
        } = {}
        } = selectedVariation || {};
    const {b2bData} = b2b || {};
    return (
        <ScrollView>
            {type == 'Simple Product' && <FlatList
                data={b2bData} 
                keyExtractor={(_, i) => i}
                ListHeaderComponent={() => <RegularItemPrice 
                    width={(dpr('wf') - dpr(40)) * 2}
                    {...props} 
                />}
                renderItem={({item}) => <B2bPrices 
                    item={item}
                    width={dpr((dpr('wf') - dpr(40)) / 5) * 2} 
                />}
                horizontal={true}
                showsHorizontalScrollIndicator={false}
                contentContainerStyle={itemPriceStyle.cont}
            />}
            {type == 'Variable Product' && success && <FlatList 
                data={selectedIsEnableB2B == 1 ? selectedB2bData : b2bData} 
                keyExtractor={(_, i) => i}
                ListHeaderComponent={() => <RegularItemPrice
                    width={(dpr('wf') - dpr(142)) * 2} 
                    {...props} 
                />}
                renderItem={({item}) => <B2bPrices 
                    item={item}
                    width={dpr((dpr('wf') - dpr(160)) / 5) * 2}
                />}
                horizontal={true}
                showsHorizontalScrollIndicator={false}
                contentContainerStyle={itemPriceStyle.cont}
            />}
            {type == 'Variable Product' && !success && <RegularItemPrice {...props}/>}
            {(type == 'Grouped Product' || type == 'External/Affiliate Product') 
            && <RegularItemPrice {...props}/>}
            <View style={itemPriceStyle.view} />
        </ScrollView>
    );
};

export default ItemPrice;

const itemPriceStyle = StyleSheet.create({
    cont: {
        paddingRight: dpr(20),
    },
    view: {
        width: dpr(15),
        backgroundColor: '#FBFBFB',
        opacity: 0.5,
        position: 'absolute',
        top: 0,
        right: 0,
        bottom: 0,
        zIndex: 9999
    }
});


